import bpy
from bpy.types import Operator
from ....libs.functions.basics import deselect_all_objects, set_active_object
from ....libs.functions.get_common_vars import get_common_vars



class FLUIDLAB_OT_ff_forces_particles_rm(Operator):
    bl_idname = "fluidlab.forces_particles_rm"
    bl_label = "Remove Force"
    bl_description = "Remove Mesh Force"
    bl_options = {'REGISTER', 'UNDO'}


    def execute(self, context):

        previous_selection = context.selected_objects
        previous_active = context.active_object

        fluid_groups = get_common_vars(context, get_fluid_groups=True)

        active_group = fluid_groups.active
        if not active_group:
            print("no acrive_group!")
            return {'CANCELLED'}

        emitters_list = active_group.emitters
        if emitters_list.is_void:
            print("emitters list is void!")
            return {'CANCELLED'}

        emitter_ob = emitters_list.get_current_emitter

        bpy.ops.object.select_all(action='DESELECT')
        set_active_object(context, emitter_ob)
        emitter_ob.select_set(True)

        psys = emitter_ob.particle_systems.active
        psys_settings = psys.settings
        ffiedl1 = psys_settings.force_field_1
        
        if hasattr(ffiedl1, "type"):
            if ffiedl1 != 'NONE':
                ffiedl1.type = 'NONE'

        if previous_active:
            set_active_object(context, previous_active)

        if previous_selection:
            bpy.ops.object.select_all(action='DESELECT')
            for ob in previous_selection:
                ob.select_set(True)

        return {'FINISHED'}